using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class DoD_FRAGMENT_DATA_RECEIVELOGDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public DoD_FRAGMENT_DATA_RECEIVELOGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public BO.DoD_FRAGMENT_DATA_RECEIVELOG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DoD_FRAGMENT_DATA_RECEIVELOG_ID)
		{
            BO.DoD_FRAGMENT_DATA_RECEIVELOG objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DoD_FRAGMENT_DATA_RECEIVELOG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, DoD_FRAGMENT_DATA_RECEIVELOG_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
        }

        public BO.DoD_FRAGMENT_DATA_RECEIVELOG GetItemByPatientSnum(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PATIENTSNUM)
        {
            BO.DoD_FRAGMENT_DATA_RECEIVELOG objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_DoD_FRAGMENT_DATA_RECEIVELOG_getitemByPatientSnum(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENTSNUM).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		public List<BO.DoD_FRAGMENT_DATA_RECEIVELOG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<BO.DoD_FRAGMENT_DATA_RECEIVELOG> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_DoD_FRAGMENT_DATA_RECEIVELOG_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, BO.DoD_FRAGMENT_DATA_RECEIVELOG objSave)
		{
			Int32? objReturn = objSave.DoD_FRAGMENT_DATA_RECEIVELOG_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DoD_FRAGMENT_DATA_RECEIVELOG_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CREATED, objSave.CREATEDBY, ref objReturn, objSave.DOD_FRAGMENT_RAW_DATA_ID, objSave.LAB_Report_DATE, objSave.ORIGINALINPUTDATE, objSave.PATIENT_ICN, objSave.PATIENTSSN, objSave.UPDATED, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 DoD_FRAGMENT_DATA_RECEIVELOG_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_DoD_FRAGMENT_DATA_RECEIVELOG_delete(CURRENT_USER, CURRENT_REGISTRY_ID, DoD_FRAGMENT_DATA_RECEIVELOG_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
